package gov.va.vinci.dart.db.impl;

import gov.va.vinci.dart.biz.PersonTask;
import gov.va.vinci.dart.biz.TaskAging;
import gov.va.vinci.dart.db.PersonTaskDAO;
import gov.va.vinci.dart.db.util.HibernateDAO;

import java.util.ArrayList;
import java.util.List;

import javax.persistence.NoResultException;
import javax.persistence.Query;

public class PersonTaskDAOImpl extends HibernateDAO implements PersonTaskDAO {

	@Override
	public void save(final PersonTask task) {
		if (task == null) {
			throw new IllegalArgumentException();
		}
		
		HibernateDAO.save(task);
	}
	
	@Override
	public void delete(PersonTask task) {
		if (task == null) {
			throw new IllegalArgumentException();
		}
		
		HibernateDAO.delete(task);
	}	
	
	@Override
	@SuppressWarnings("unchecked")
	public List<PersonTask> listByOwner(final int ownerId) {
		Query query = createQuery("from PersonTask where personOwner.id=:oid");
		query.setParameter("oid", ownerId);
		return (List<PersonTask>)query.getResultList();
	}
	
	@Override
	@SuppressWarnings("unchecked")
	public List<PersonTask> listOpenByOwner(final int ownerId) {
		Query query = createQuery("from PersonTask where personOwner.id=:oid and completedOn is null");	//not yet completed
		query.setParameter("oid", ownerId);
		return (List<PersonTask>)query.getResultList();
	}
	
	@Override
	@SuppressWarnings("unchecked")
	public List<PersonTask> listOpenByRequestId(final int requestId) {
		Query query = createQuery("from PersonTask where request.id=:rid and completedOn is null");	//not yet completed
		query.setParameter("rid", requestId);
		return (List<PersonTask>)query.getResultList();
	}	
	
	@Override
	@SuppressWarnings("unchecked")
	public List<PersonTask> listOpenByWorkflowAndRequestId(final int workflowId, final int requestId) {
		Query query = createQuery("from PersonTask where request.id=:rid and completedOn is null and (workflow is not null and workflow.id=:wid)");	//not yet completed
		query.setParameter("rid", requestId);
		query.setParameter("wid", workflowId);
		return (List<PersonTask>)query.getResultList();
	}	
	
	@Override
	public TaskAging getTaskAging(final int ownerId) {
		// TODO- fix this query
//		Query query = createQuery("select count(*) from PersonTask where personOwner.id=:oid and createdOn is not null");
//		query.setParameter("oid", ownerId);
//		Object obj = query.getSingleResult();
		
		// TODO- return real results
		TaskAging result = new TaskAging(1, 2, 3, 4);
		
		return result;
	}
	
	@Override
	@SuppressWarnings("unchecked")
	public List<PersonTask> listAllPersonTasks() {
		Query query = createQuery("from PersonTask");

		try {
			return (List<PersonTask>)query.getResultList();
		} catch (NoResultException e) {
			return new ArrayList<PersonTask>();
		}
	}	

	@Override
	@SuppressWarnings("unchecked")
	public List<PersonTask> listAllOpenPersonTasks() {
		Query query = createQuery("from PersonTask where completedOn is null");	//not yet completed

		try {
			return (List<PersonTask>)query.getResultList();
		} catch (NoResultException e) {
			return new ArrayList<PersonTask>();
		}
	}

	@Override
	public PersonTask findById(int taskId) {
		Query query = createQuery("from PersonTask where id=:tid");
		query.setParameter("tid", taskId);
		return (PersonTask)query.getSingleResult();
	}	

}
